
#source detailed graphs for continuous and ordinal

cbeet1        # Beetroot - P. ultimum 1
cbeet2        # Beetroot - P. ultimum 2
cphoma1       # Onion - S. terrestris 1
cphoma2       # Onion - S. terrestris 2
conifus1      # Onion - F. oxysporum 1
conifus2      # Onion - F. oxysporum 2 
cspipy1       # Spinach - P. ultimum 1
cspipy2       # Spinach - P. ultimum 2
cfusspi1      # Spinach - F. oxysporum 1  
cfusspi2      # Spinach - F. oxysporum 2
ccor1         # Coriander - Pythium sp. 1
ccor2         # Coriander - Pythium sp. 2
cpepsee1      # go first # Pepper seedlings - P. capsici 1
cpepsee2      # go first # Pepper seedlings - P. capsici 2
cpeppl1       # Pepper plants - P. capsici 1 
cpeppl2       # Pepper plants - P. capsici 2 
cfeslat       # Red fescue - L. fuciformis 
cperlat       # Perennial ryegrass - L. fuciformis
cperpuc       # Perennial ryegrass - Puccinia sp.

ex <- list(theme(plot.margin = unit(c(0.5,0.5,0,0.5), "lines"))) #for graphs
exl <- list(theme(plot.margin = unit(c(0.5,0.5,0,0), "lines"))) #for the legend

page1 <- plot_grid((fullegend + exl),
          (cbeet1  + ex),   #A1
          (cbeet2 + ex),   #A2
          (cphoma1 + ex),  #B1
          (cphoma2 + ex),  #B2
          ncol = 1)
          
page2 <- plot_grid((conifus1+ ex), #C1
          (conifus2+ ex), #C2
          (cspipy1+ ex),  #D1
          (cspipy2+ ex),  #D2
          (cfusspi1+ ex), #E1
          ncol = 1) 

page3 <- plot_grid((cfusspi2+ ex), #E2
          (ccor1+ ex),    #F1
          (ccor2+ ex),    #F2
          (cpeppl1+ ex),  #G1
          (cpeppl2+ ex),  #G2
          ncol = 1) 

page4 <- plot_grid((cpepsee1+ ex), #H1
          (cpepsee2+ ex), #H2
          (cfeslat+ ex),  #I
          (cperlat+ ex),  #J
          (cperpuc+ ex),  #K
          ncol = 1) 

#for full size, save one by one as pdf in A4 format

#use empty argument to create space around plot
e <- get_legend(b1)

#setwd()
pdf('./v2_supplementaryTEST.pdf', width=8.27, height=11.69)

plot_grid(e, e, e,  
          e, page1, e,
          e, e, e,
          ncol=3, nrow=3,
          rel_heights = c(0.09, 0.82, 0.09),
          rel_widths = c(0.12, 0.76, 0.12))

plot_grid(e, e, e,  
          e, page2, e,
          e, e, e,
          ncol=3, nrow=3,
          rel_heights = c(0.09, 0.82, 0.09),
          rel_widths = c(0.12, 0.76, 0.12))

plot_grid(e, e, e,  
          e, page3, e,
          e, e, e,
          ncol=3, nrow=3,
          rel_heights = c(0.09, 0.82, 0.09),
          rel_widths = c(0.12, 0.76, 0.12))

plot_grid(e, e, e,  
          e, page4, e,
          e, e, e,
          ncol=3, nrow=3,
          rel_heights = c(0.09, 0.82, 0.09),
          rel_widths = c(0.12, 0.76, 0.12))

dev.off()

